#pragma once

#include "LF_ID_C_API.h"
#include "afxwin.h"
#include "RFIDDriver.h"
using namespace Psion::RFID;

class CDlgContScan : public CPropertyPage
{
	DECLARE_DYNAMIC(CDlgContScan)
private:
	CListCtrl	m_ctrlCard;
	CButton		m_ctrlScan;
	CButton		m_ctrlStop;

	SDKHANDLE	m_hReader;
	RFIDDriver	m_rfidDriver;
	UINT		m_nTimer;

private:
	void EnableBtn(BOOL bScan);
	void InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen);
	void InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage);

public:
	CDlgContScan();
	virtual ~CDlgContScan();

	enum { IDD = IDD_DIALOG_CONT_SCAN };

protected:
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	afx_msg void OnBnClickedBtnContScan();

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedBtnExitScan();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
};
